/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.utils;

import at.petrak.hexcasting.api.casting.SpellList;
import at.petrak.hexcasting.api.casting.iota.BooleanIota;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.EntityIota;
import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import at.petrak.hexcasting.api.casting.math.HexAngle;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import com.samsthenerd.duckyperiphs.hexcasting.utils.HexalIotaLuaUtils;
import com.samsthenerd.duckyperiphs.hexcasting.utils.MoreIotasIotaLuaUtils;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public class IotaLuaUtils {
    public static Iota getIota(Object LuaObject, class_3218 world) {
        Iota moreIotasIota;
        Iota hexalIota;
        if (LuaObject == null) {
            return new NullIota();
        }
        if (LuaObject instanceof Number) {
            return new DoubleIota(((Number)LuaObject).doubleValue());
        }
        if (LuaObject instanceof Boolean) {
            return new BooleanIota(((Boolean)LuaObject).booleanValue());
        }
        if (LuaObject instanceof Map) {
            Map tableArray;
            ListIota list;
            Map rawTable = (Map)LuaObject;
            if (rawTable.isEmpty()) {
                return new ListIota(new ArrayList());
            }
            Class<?> keyClass = rawTable.keySet().iterator().next().getClass();
            if (keyClass == Double.class && (list = IotaLuaUtils.tryMakeListIota(tableArray = rawTable, world)) != null) {
                return list;
            }
            if (keyClass == String.class) {
                Map table = rawTable;
                if (table.containsKey("null") && table.size() == 1) {
                    return new NullIota();
                }
                if (table.size() == 0) {
                    return new ListIota(new ArrayList());
                }
                if (table.size() == 3 && table.containsKey("x") && table.containsKey("y") && table.containsKey("z")) {
                    if (table.get("x") instanceof Number && table.get("y") instanceof Number && table.get("z") instanceof Number) {
                        double x = ((Number)table.get("x")).doubleValue();
                        double y = ((Number)table.get("y")).doubleValue();
                        double z = ((Number)table.get("z")).doubleValue();
                        return new Vec3Iota(new class_243(x, y, z));
                    }
                    return new GarbageIota();
                }
                if (table.size() == 2 && table.containsKey("startDir") && table.containsKey("angles")) {
                    if (table.get("startDir") instanceof String && table.get("angles") instanceof String) {
                        String startDirRaw = (String)table.get("startDir");
                        String anglesSeqRaw = (String)table.get("angles");
                        HexDir startDir = HexDir.fromString((String)startDirRaw);
                        List<HexAngle> anglesSeq = IotaLuaUtils.stringToAngleSeq(anglesSeqRaw);
                        if (startDir == null || anglesSeq == null) {
                            return new GarbageIota();
                        }
                        HexPattern pat = new HexPattern(startDir, anglesSeq);
                        return new PatternIota(pat);
                    }
                    return new GarbageIota();
                }
                if (table.containsKey("uuid")) {
                    if (table.get("uuid") instanceof String) {
                        String uuidString = (String)table.get("uuid");
                        if (uuidString == null) {
                            return new GarbageIota();
                        }
                        class_1297 ent = world.method_14190(UUID.fromString(uuidString));
                        if (ent == null) {
                            return new GarbageIota();
                        }
                        if (ent.method_31747()) {
                            return new NullIota();
                        }
                        return new EntityIota(ent);
                    }
                    return new GarbageIota();
                }
            }
        }
        if (Platform.isModLoaded((String)"hexal") && (hexalIota = HexalIotaLuaUtils.getHexalIota(LuaObject, world)) != null) {
            return hexalIota;
        }
        if (Platform.isModLoaded((String)"moreiotas") && (moreIotasIota = MoreIotasIotaLuaUtils.getMoreIotasIota(LuaObject)) != null) {
            return moreIotasIota;
        }
        return new GarbageIota();
    }

    public static Object getLuaObject(class_2487 tag, class_3218 world) {
        if (tag == null) {
            return null;
        }
        Iota iota = IotaType.deserialize((class_2487)tag, (class_3218)world);
        return IotaLuaUtils.getLuaObject(iota, world);
    }

    public static Object getLuaObject(Iota iota, class_3218 world) {
        Object moreIotasObject;
        Object hexalIota;
        if (iota instanceof NullIota) {
            HashMap<String, Boolean> nullTable = new HashMap<String, Boolean>();
            nullTable.put("null", true);
            return nullTable;
        }
        if (iota instanceof GarbageIota) {
            return IotaLuaUtils.makeGarbageTable();
        }
        if (iota instanceof DoubleIota) {
            return ((DoubleIota)iota).getDouble();
        }
        if (iota instanceof BooleanIota) {
            return ((BooleanIota)iota).getBool();
        }
        if (iota instanceof Vec3Iota) {
            class_243 vec = ((Vec3Iota)iota).getVec3();
            HashMap<String, Double> vecTable = new HashMap<String, Double>();
            vecTable.put("x", vec.field_1352);
            vecTable.put("y", vec.field_1351);
            vecTable.put("z", vec.field_1350);
            return vecTable;
        }
        if (iota instanceof ListIota) {
            SpellList list = ((ListIota)iota).getList();
            ArrayList<Object> luaList = new ArrayList<Object>();
            for (Iota i : list) {
                luaList.add(IotaLuaUtils.getLuaObject(i, world));
            }
            return luaList;
        }
        if (iota instanceof EntityIota) {
            class_1297 ent = ((EntityIota)iota).getEntity();
            if (ent.method_31747()) {
                // empty if block
            }
            HashMap<String, Object> entTable = new HashMap<String, Object>();
            entTable.put("uuid", ent.method_5845());
            entTable.put("name", ent.method_5477().getString());
            entTable.put("isPlayer", ent.method_31747());
            return entTable;
        }
        if (iota instanceof PatternIota) {
            HexPattern pat = ((PatternIota)iota).getPattern();
            return IotaLuaUtils.getLuaObject(pat);
        }
        if (Platform.isModLoaded((String)"hexal") && (hexalIota = HexalIotaLuaUtils.getHexalObject(iota, world)) != null) {
            return hexalIota;
        }
        if (Platform.isModLoaded((String)"moreiotas") && (moreIotasObject = MoreIotasIotaLuaUtils.getMoreIotasObject(iota)) != null) {
            return moreIotasObject;
        }
        return null;
    }

    public static Map<String, Object> getLuaObject(HexPattern pat) {
        HashMap<String, Object> patTable = new HashMap<String, Object>();
        if (pat == null) {
            return null;
        }
        patTable.put("startDir", pat.getStartDir().toString());
        patTable.put("angles", pat.anglesSignature());
        return patTable;
    }

    public static String getIotaTypeID(IotaType<?> type) {
        return HexIotaTypes.REGISTRY.method_10221(type).toString();
    }

    private static Map<String, Object> makeGarbageTable() {
        HashMap<String, Object> garbageTable = new HashMap<String, Object>();
        garbageTable.put("garbage", true);
        return garbageTable;
    }

    private static List<HexAngle> stringToAngleSeq(String anglesSeqRaw) {
        ArrayList<HexAngle> anglesSeq = new ArrayList<HexAngle>();
        for (int i = 0; i < anglesSeqRaw.length(); ++i) {
            HexAngle angle = IotaLuaUtils.angleFromChar(anglesSeqRaw.substring(i, i + 1));
            if (angle == null) {
                return null;
            }
            anglesSeq.add(angle);
        }
        return anglesSeq;
    }

    private static HexAngle angleFromChar(String _c) {
        switch (_c) {
            case "w": {
                return HexAngle.FORWARD;
            }
            case "e": {
                return HexAngle.RIGHT;
            }
            case "d": {
                return HexAngle.RIGHT_BACK;
            }
            case "s": {
                return HexAngle.BACK;
            }
            case "a": {
                return HexAngle.LEFT_BACK;
            }
            case "q": {
                return HexAngle.LEFT;
            }
        }
        return null;
    }

    private static ListIota tryMakeListIota(Map<Double, Object> luaTable, class_3218 world) {
        int keyCount = luaTable.size();
        ArrayList<Object> iotaList = new ArrayList<Object>(keyCount);
        for (int i = 1; i <= keyCount; ++i) {
            if (!luaTable.containsKey(i)) {
                iotaList.add(i - 1, new NullIota());
            }
            iotaList.add(i - 1, IotaLuaUtils.getIota(luaTable.get(i), world));
        }
        return new ListIota(iotaList);
    }
}

